<?php
#region Fields
if (isset($_SERVER['HTTP_ORIGIN'])) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');    // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
        header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

    exit(0);
}

header('Content-Type: application/json');
date_default_timezone_set('America/Toronto');
set_time_limit(0);
require __DIR__ . '/vendor/autoload.php';
use Firebase\JWT\JWT;
$key     = "EymrGmrVYOqYpKha";


$pdo7 = new PDO('mysql:host=51.79.80.77;port=7999;dbname=xtream_iptvpro;charset=utf8mb4', 'user_iptvpro', 'ACYqxJ6ahimPYWG6');
$pdo7->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo7->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_OBJ);
$pdo7->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
$pdo7->setAttribute(PDO::MYSQL_ATTR_INIT_COMMAND, "SET NAMES 'utf8mb4'");
$fluent7 = new FluentPDO($pdo7);


$action = isset($_GET['a']) ? $_GET['a'] : null;
#endregion

#region Functions
switch ($action) {
    #region UsersXtreamUI
    case 'addUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(addUserXtreamUI($data)));
    break;
    
    case 'deleteUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(DeleteUserXtreamUI($data)));
    break;
    
    case 'updateUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(UpdateUserXtreamUI($data)));
    break;
    
    case 'repairUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(repairUserXtreamUI($data)));
    break;
    #endregion
}
#endregion

//$GLOBALS['fluent']

#region UsersXtreamUI

function repairUserXtreamUI($data)
{
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["userOld"])->fetchAll();
    
    if(sizeof($query) > 0)
    {
        return UpdateUserXtreamUI($data);
    }else
    {
        return addUserXtreamUI($data);
    }
}

function addUserXtreamUI($data)
{
 
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["user"])->fetchAll();
    if(sizeof($query) > 0)
    {
        return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $query
        );
    }
    else{
        $values_1 = array(
            'member_id' => 1, 
            'username' => $data["user"],
            'password' => $data["pass"], 
            'exp_date' => $data["date"],
            'admin_enabled' => 1, 
            'enabled' => 1,
            'admin_notes' => '', 
            'reseller_notes' => '',
            'bouquet' => '["1"]', 
            'max_connections' =>$data["connection"],
            'is_restreamer' => 0, 
            'allowed_ips' => '[]',
            'allowed_ua' => '[]', 
            'is_trial' => 0,
            'created_at' => 1584944180, 
            'created_by' => 1,
            'is_mag' => 0,
            'is_e2' => 0, 
            'force_server_id' => 0,
            'is_isplock' => 0, 
            'isp_desc' => '', 
            'forced_country' => '',
            'is_stalker' => 0, 
            'bypass_ua' => 0,
            'play_token' => ''
        );
        
        
        $query = $GLOBALS['fluent7']->insertInto('users')->values($values_1)->execute();
   
            
        $values_one = array(
            'user_id' => $query,
            'access_output_id' => 1
        );
        
        $values_two = array(
            'user_id' => $query,
            'access_output_id' => 2
        );
        
        $values_three = array(
            'user_id' => $query,
            'access_output_id' => 3
        );
        
        $query_one = $GLOBALS['fluent7']->insertInto('user_output')->values($values_one)->execute();
        $query_two = $GLOBALS['fluent7']->insertInto('user_output')->values($values_two)->execute();
        $query_three = $GLOBALS['fluent7']->insertInto('user_output')->values($values_three)->execute();

    }
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $query
        );
}

function DeleteUserXtreamUI($data)
{
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["user"])->where('password', $data["pass"])->fetchAll();
    
    if(sizeof($query) > 0){
        $queryd = $GLOBALS['fluent7']->deleteFrom('user_output')->where('id', $query[0]->id)->execute();
        $queryd = $GLOBALS['fluent7']->deleteFrom('users')->where('id', $query[0]->id)->execute();
    }
    
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $data
        );
}

function UpdateUserXtreamUI($data)
{
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["userOld"])->fetchAll();

    
    $values_1 = array(
        'username' => $data["user"],
        'password' => $data["pass"], 
        'exp_date' => $data["date"],
        'max_connections' =>$data["connection"]
    );
    
    if(sizeof($query) > 0){
        $queryd = $GLOBALS['fluent7']->update('users')->set($values_1)->where('id', $query[0]->id)->execute();
    }
    

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => sizeof($query),
            "Data" => $data
        );
    
}
#endregion


#endregion